;;Example of a ViDAL (ViSta Data Analysis Language) script file.
;;Load this file with the Load-Edit command.

;;Univariate Analysis examples


(setf *demo-data-path* (strcat *default-path* "help\\demos\\datademo\\"))
(setf *datademo-data-path* (strcat *default-path* "help\\demos\\datademo\\"))



(defun load-datasets (datasets-list)
  (unless *all-demo-data-loaded* 
          (let ((indir (get-working-directory)))
            (set-working-directory *demo-data-path*)
            (mapcar #'(lambda (file) 
                        (load-data (strcat *demo-data-path* file))) 
                    datasets-list)
            (set-working-directory indir))))

(unless *univar-demo-data-loaded* 
        (load-datasets (list "french.lsp" "reading.lsp"))
        (unless *princomp-demo-data-loaded* (load-datasets (list "p309799.lsp")))
        (setf *univar-demo-data-loaded* t))

(defun make-control-panel ()
  (let* ((text0 (send text-item-proto :new (format nil "DEMONSTRATE TYPES OF~%UNIVARIATE ANALYSIS")))
         (text1 (send text-item-proto :new (format nil "CHOOSE TYPE")))
         (text2 (send text-item-proto :new (format nil "REVIEW RESULTS")))
         (choice1 (send choice-item-proto :new
                        (list "1 Sample, Known Pop. Variance"
                              "1 Sample, Unknown Pop. Variance" 
                              "2 Independent Samples" 
                              "2 Paired Samples")
                        :value 0 
                        :action #'(lambda () (choose-data-analysis))))
         (choice2 (send choice-item-proto :new
                        (list "About the Data" 
                              "Visualize Data" 
                              "Summarize Data"
                              "Visualize Model" 
                              "Report Model" 
                              "Save Model") 
                        :value 0 
                        :action #'(lambda () (choose-model-review))))
         (dialog (send dialog-proto :new
                       (list text0 text1 choice1 text2 choice2)
                       :show nil))
         (previous-window)
         )
    (send dialog :title "Univariate Analyses")
    (send dialog :show-window)
    (send dialog :size 
          (floor (* .75 (first (send dialog :size))))
          (second (send dialog :size)))
    (defun choose-data-analysis ()
      (when previous-window (send previous-window :close))
      (eval (select (list '(single-known) '(single-unknown) 
                    '(independent) '(dependent)) (send choice1 :value))))
    (defun choose-model-review ()
      (when previous-window (send previous-window :close))
      (setf previous-window
            (eval (select (list '(about-these-data) '(visualize-data) '(summarize-data) 
                                '(visualize-model) '(report-model) 
                                '(save-model)) (send choice2 :value))))
      (defmeth previous-window :close ()
        (call-next-method)
        (setf previous-window nil)))
    dialog))
    


(let* ((action nil) (model nil)
       (efs (effective-screen-size))
       (cp (make-control-panel))
       (size (list 256 (second (send cp :size)))))
  (apply #'send cp :size (- size '(0 37)))
  (apply #'send cp :frame-location (- efs (send cp :size)))
  (defun do-action ()
    (unless model
            (setf model t)
            (apply #'send cp :size size)
            (apply #'send cp :frame-location (- efs (send cp :size)))))
  ;;Single sample, known population variance
  (defun single-known ()
    (do-action)
    (setcd p309799)
    (univariate-analysis :variable "SATMath" :mu 460  :sigma 100 :direction 1))
  ;Single sample, unknown population variance
  (defun single-unknown ()
    (do-action)
    (setcd french)
    (univariate-analysis :variable "Difference" :direction 1))
  ;Two independent samples
  (defun independent ()
    (do-action)
    (setcd reading)
    (univariate-analysis :variable "DRP-Score" :class "Group"))
;Two paired samples
  (defun dependent ()
    (do-action)
    (setcd french)
    (univariate-analysis :variable '("PostTest" "PreTest") :direction 1)
    ))
 

 